<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require_once('./../modelo/odoo_producto.php');
require_once('./../modelo/odoo_lista_precio.php');

$tag_id = OdooProducto::getProductTagId('versaprink');
$productos = OdooProducto::searchProducts($tag_id[0]);

// Extraemos el id del producto que coincida con el nombre "Cable Management Box"
$productosFiltrados = array_filter(
    $productos,
    function ($producto) {
        return $producto['name'] == "Hamburguesa de queso";
    }
);

$producto = reset($productosFiltrados);

// // Extrae el id del producto si se encuentra
$productId = $producto ? $producto['id'] : 0;

// // 1. Obtenemos el precio de un producto en una lista de precios especifica
// // lo que retorna es el precio literal, no el objeto
$price_list_items = OdooListaPrecio::getPriceRulesByProductId(2);
// // $price = OdooListaPrecio::getPriceByProductIdAndPriceListName(1, "mtm-10");

echo json_encode($price_list_items[0]['pricelist_id'][1]);