<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

require_once('./../modelo/odoo_inventario.php');
require_once('./../modelo/odoo_producto.php');

// 1. Obtenemos el id del almacen por su nombre
// $datawarehouse = OdooInventario::getAlmacenPorNombre("Cursodontic");
// $datawarehouse2 = OdooInventario::getAlmacenPorNombre("ZAPATERIA URTADO ÑERI");
$datawarehouse3 = OdooInventario::getAlmacenPorNombre("Algarín");
// $datawarehouse4 = OdooInventario::getAlmacenPorNombre("Chicago 1");
// $datawarehouse5 = OdooInventario::getAlmacenPorNombre("MX Company");

// 2. Buscar los productos con la etiqueta 'versaprink'
$tag_id = OdooProducto::getProductTagId('versaprink');
$productos = OdooProducto::searchProducts($tag_id);

// Extraemos el id del producto que coincida con el nombre "Cable Management Box"
$productosFiltrados = array_filter(
    $productos,
    function ($producto) {
        return $producto['name'] == "Cable Management Box";
    }
);
$producto = reset($productosFiltrados);

// Extrae el id del producto si se encuentra
$productId = $producto ? $producto['id'] : 0;

// 3. Obtenemos la cantidad de productos en inventario que hay en un almacen especifico
// $cantidad = OdooInventario::getStockByAlmacenId($productId, $datawarehouse[0]['id']);
// $cantidad2 = OdooInventario::getStockByAlmacenId($productId, $datawarehouse2[0]['id']);
$cantidad3 = OdooInventario::getStockByAlmacenId($productId, $datawarehouse3[0]['id']);
$cantidad4 = OdooInventario::getFreeStockByAlmacenId($productId, $datawarehouse3[0]['id']);
// $cantidad4 = OdooInventario::getStockByAlmacenId($productId, $datawarehouse4[0]['id']);
// $cantidad5 = OdooInventario::getStockByAlmacenId($productId, $datawarehouse5[0]['id']);

// echo "Cursodontic: \n";
// echo json_encode($cantidad);
// echo "ZAPATERIA URTADO ÑERI: \n";
// echo json_encode($cantidad2);
echo "My Company: \n";
echo "Stock: ";
echo json_encode($cantidad3);
echo "\n";
echo "Free Stock: ";
echo json_encode($cantidad4);
// echo "Chicago 1: \n";
// echo json_encode($cantidad4);
// echo "MX Company: \n";
// echo json_encode($cantidad5);
