<?php

require_once 'conexion.php';

class ZonaExtendidaExpress
{
    public static function mdlGetZonasExtendidasExpress()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM zonas_extendidas_express WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlIsZonaExtendidaExpress($cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM zonas_extendidas_express WHERE cp = :cp AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':cp', $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlIsZonaExtendidaDHL($cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM zonas_extendidas_dhl WHERE cp = :cp AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':cp', $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetZonaExtendidaExpressById($id_zonas_extendidas_express)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM zonas_extendidas_express WHERE id_zonas_extendidas_express = :id_zonas_extendidas_express AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zonas_extendidas_express', $id_zonas_extendidas_express);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddZonaExtendidaExpress($cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO zonas_extendidas_express (cp) VALUES (:cp)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':cp', $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateZonaExtendidaExpress($id_zonas_extendidas_express, $cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE zonas_extendidas_express SET cp = :cp WHERE id_zonas_extendidas_express = :id_zonas_extendidas_express";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zonas_extendidas_express', $id_zonas_extendidas_express);
        $stmt->bindParam(':cp', $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteZonaExtendidaExpress($id_zonas_extendidas_express)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM zonas_extendidas_express WHERE id_zonas_extendidas_express = :id_zonas_extendidas_express";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zonas_extendidas_express', $id_zonas_extendidas_express);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoZonaExtendidaExpress($id_zonas_extendidas_express, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE zonas_extendidas_express SET activo = :activo WHERE id_zonas_extendidas_express = :id_zonas_extendidas_express";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zonas_extendidas_express', $id_zonas_extendidas_express);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
