<?php

require_once 'conexion.php';

class Wishlist
{
    public static function mdlAddProductoWishlist($id_usuario, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO wishlist (id_usuario, id_producto) VALUES (:id_usuario, :id_producto)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetWishlistUsuario($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT producto.*, categoria.color AS color_categoria FROM wishlist INNER JOIN producto ON wishlist.id_producto = producto.id_producto
        INNER JOIN producto_categoria ON producto.id_producto = producto_categoria.id_producto
        INNER JOIN categoria ON producto_categoria.id_categoria = categoria.id_categoria
        WHERE wishlist.id_usuario = :id_usuario ORDER BY wishlist.fecha_alta DESC";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteProductoWishlist($id_producto, $id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM wishlist WHERE id_usuario = :id_usuario AND id_producto = :id_producto";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlVerificarExistenciaWishlist($id_usuario, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM wishlist WHERE id_usuario = :id_usuario AND id_producto = :id_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlObtenerWishlistsAbandonados()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT wishlist.id_whishliwst, wishlist.id_usuario, wishlist.id_producto, producto.nombre, producto.imagenes, producto.url_pagina, precio.precio FROM wishlist
        INNER JOIN producto ON wishlist.id_producto = producto.id_producto
        INNER JOIN precio ON producto.id_precio = precio.id_precio
        WHERE producto.activo = 1 AND wishlist.fecha_alta < NOW() - INTERVAL 24 HOUR
        ORDER BY wishlist.fecha_alta DESC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}
