<?php

require_once 'conexion.php';

class TipoSoporteTecnico
{
    public static function mdlAddTipoSoporteTecnico($nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO tipo_soporte_tecnico (nombre, descripcion) VALUES (:nombre, :descripcion)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetTipoSoporteTecnico($id_tipo_soporte_tecnico)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM tipo_soporte_tecnico WHERE id_tipo_soporte_tecnico = :id_tipo_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetTiposSoporteTecnico($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM tipo_soporte_tecnico WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateTipoSoporteTecnico($id_tipo_soporte_tecnico, $nombre, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE tipo_soporte_tecnico SET nombre = :nombre, descripcion = :descripcion, activo = :activo WHERE id_tipo_soporte_tecnico = :id_tipo_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoTipoSoporteTecnico($id_tipo_soporte_tecnico, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE tipo_soporte_tecnico SET activo = :activo WHERE id_tipo_soporte_tecnico = :id_tipo_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteTipoSoporteTecnico($id_tipo_soporte_tecnico)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM tipo_soporte_tecnico WHERE id_tipo_soporte_tecnico = :id_tipo_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
