<?php

class SEPOMEX
{
    public static function mdlGetDireccionByCP($cp)
    {
        $url = "https://sepomex.icalialabs.com/api/v1/zip_codes?zip_code=" . $cp;
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception('Curl error: ' . curl_error($ch));
        }

        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($httpCode != 200) {
            throw new Exception("Unexpected HTTP code: $httpCode");
        }

        curl_close($ch);

        $decodedResponse = json_decode($response, true);
        if ($decodedResponse === null && json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception('JSON decode error: ' . json_last_error_msg());
        }

        return $decodedResponse;
    }
}
