<?php

require_once 'conexion.php';

class RedSocial
{
    
    public static function mdlGetAllRedesSociales()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM red_social ORDER BY id_red_social ASC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
    
    public static function mdlGetRedSocialByName($nombre)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM red_social WHERE nombre = :nombre";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
    
    public static function mdlGetRedesSociales()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM red_social WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddRedSocial($nombre, $url, $icono_fontawesome, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO red_social (nombre, url, icono_fontawesome, activo) VALUES (:nombre, :url, :icono_fontawesome, :activo)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":url", $url);
        $stmt->bindParam(":icono_fontawesome", $icono_fontawesome);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateRedSocialByNombre($nombre, $url, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE red_social SET url = :url, activo = :activo WHERE nombre = :nombre";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":url", $url, PDO::PARAM_STR);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":nombre", $nombre, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateRedSocial($id_red_social, $url)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE red_social SET url = :url WHERE id_red_social = :id_red_social";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":url", $url);
        $stmt->bindParam(":id_red_social", $id_red_social, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteRedSocial($id_red_social)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM red_social WHERE id_red_social = :id_red_social";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_red_social", $id_red_social);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}
