<?php

require_once 'conexion.php';

class Proveedor
{
    public static function mdlGetAllProveedores()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM proveedor ORDER BY id_proveedor DESC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetProveedores($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM proveedor WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetProveedorById($id_proveedor)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM proveedor WHERE id_proveedor = :id_proveedor AND activo = 1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_proveedor", $id_proveedor, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetProveedorByIdProducto($id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT proveedor.* FROM proveedor
        INNER JOIN producto ON proveedor.id_proveedor = producto.id_proveedor
        WHERE producto.id_producto = :id_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddProveedor($nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO proveedor (nombre, descripcion) VALUES (:nombre, :descripcion)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateProveedor($id_proveedor, $nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE proveedor SET nombre = :nombre, descripcion = :descripcion WHERE id_proveedor = :id_proveedor";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":id_proveedor", $id_proveedor, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteProveedor($id_proveedor)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM proveedor WHERE id_proveedor = :id_proveedor";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_proveedor", $id_proveedor, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateActivoProveedor($id_proveedor, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE proveedor SET activo = :activo WHERE id_proveedor = :id_proveedor";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_proveedor", $id_proveedor, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}
