<?php

require_once 'conexion.php';

class ProductoVariacion
{

    // MODELOS CREADOS PARA LA ADMINISTRACIÓN DE LA BASE DE DATOS

    public static function mdlAddVarianteProductoById($id_producto, $id_producto_padre, $id_tipo_variacion, $atributo_variacion, $valor_atributo_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO producto_variacion (id_producto, id_producto_padre, id_tipo_variacion, atributo_variacion, valor_atributo_variacion) 
                VALUES (:id_producto, :id_producto_padre, :id_tipo_variacion, :atributo_variacion, :valor_atributo_variacion)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto_padre', $id_producto_padre, PDO::PARAM_INT);
        $stmt->bindParam(':id_tipo_variacion', $id_tipo_variacion, PDO::PARAM_INT);
        $stmt->bindParam(':atributo_variacion', $atributo_variacion, PDO::PARAM_STR);
        $stmt->bindParam(':valor_atributo_variacion', $valor_atributo_variacion, PDO::PARAM_STR);

        $stmt->execute();

        $id_producto_variacion = $db->lastInsertId();

        $db = null;

        return $id_producto_variacion;
    }
    
    public static function mdlGetProductoVariaciones($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM producto_variacion WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetProductoVariacionByIdProducto($id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_variacion.id_producto_variacion, producto_variacion.id_producto, producto_variacion.id_producto_padre, tipo_variacion.id_tipo_variacion, tipo_variacion.nombre_variacion, producto_variacion.atributo_variacion, producto_variacion.valor_atributo_variacion 
                FROM producto_variacion
                INNER JOIN producto ON producto_variacion.id_producto = producto.id_producto
                INNER JOIN tipo_variacion ON producto_variacion.id_tipo_variacion = tipo_variacion.id_tipo_variacion
                WHERE producto.activo = 1 AND producto_variacion.id_producto = :id_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto", $id_producto);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetProductoVariacionByIdProductoPadre($id_producto_padre)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_variacion.id_producto_variacion, producto_variacion.id_producto, tipo_variacion.id_tipo_variacion, tipo_variacion.nombre_variacion, producto_variacion.id_producto_padre, producto_variacion.atributo_variacion, producto_variacion.valor_atributo_variacion, producto.nombre, producto.id_precio, producto.sku, producto.id_precio_descuento 
                FROM producto_variacion 
                INNER JOIN tipo_variacion ON producto_variacion.id_tipo_variacion = tipo_variacion.id_tipo_variacion 
                LEFT JOIN producto ON producto_variacion.id_producto = producto.id_producto
                WHERE producto_variacion.id_producto_padre = :id_producto_padre ORDER BY producto_variacion.id_producto ASC";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );
        
        // if ($atributo_variacion == null || $atributo_variacion == '') {
        //     $sql .= " ORDER BY producto_variacion.id_producto ASC";
        // } else {
        //     $sql .= " ORDER BY 
        //                 CASE 
        //                     WHEN producto_variacion.atributo_variacion = :atributo_variacion THEN 0
        //                     ELSE 1 
        //                 END, 
        //                 producto_variacion.id_producto ASC";
        // }

        $stmt = $db->prepare($sql);

        // if ($atributo_variacion != null && $atributo_variacion != '') {
        //     $stmt->bindParam(":atributo_variacion", $atributo_variacion);
        // }

        $stmt->bindParam(":id_producto_padre", $id_producto_padre);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetProductoVariacionByIdProductoHijo($id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_variacion.id_producto_variacion, producto_variacion.id_producto, tipo_variacion.id_tipo_variacion, tipo_variacion.nombre_variacion, producto_variacion.id_producto_padre, producto_variacion.atributo_variacion, producto_variacion.valor_atributo_variacion, producto.nombre, producto.sku
                FROM producto_variacion 
                INNER JOIN tipo_variacion ON producto_variacion.id_tipo_variacion = tipo_variacion.id_tipo_variacion 
                LEFT JOIN producto ON producto_variacion.id_producto_padre = producto.id_producto
                WHERE producto_variacion.id_producto = :id_producto ORDER BY producto_variacion.id_producto ASC";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto", $id_producto);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddProductoVariacion($id_producto, $id_producto_padre, $id_tipo_variacion, $atributo_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO producto_variacion (id_producto, id_producto_padre, id_tipo_variacion, atributo_variacion) VALUES (:id_producto, :id_producto_padre, :id_tipo_variacion, :atributo_variacion)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto", $id_producto);
        $stmt->bindParam(":id_producto_padre", $id_producto_padre);
        $stmt->bindParam(":id_tipo_variacion", $id_tipo_variacion);
        $stmt->bindParam(":atributo_variacion", $atributo_variacion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteProductoVariacion($id_producto_variacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM producto_variacion WHERE id_producto_variacion = :id_producto_variacion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto_variacion", $id_producto_variacion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
