<?php

require_once 'conexion.php';

class ProductoCategoria
{

    public static function mdlDeleteCategoriaById($id_producto_categoria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM producto_categoria WHERE id_producto_categoria = :id_producto_categoria";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_producto_categoria", $id_producto_categoria, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCategoriaAndSubcategoriaById($id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM producto_categoria WHERE id_producto = :id_producto";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);
        $stmt->execute();

        $response = $stmt->fetch(PDO::FETCH_ASSOC);

        $db = null;

        return $response;
    }

    public static function mdlAddCategoriaAndSubcategoriaByProducto($id_producto, $id_categoria, $id_subcategoria){
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO producto_categoria (id_producto, id_categoria, id_subcategoria) VALUES (:id_producto, :id_categoria, :id_subcategoria)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(":id_categoria", $id_categoria, PDO::PARAM_INT);
        $stmt->bindParam(":id_subcategoria", $id_subcategoria, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}