<?php

require_once 'conexion.php';

class PrecioZonaExtendida
{
    public static function mdlGetPrecioZonaExtendida()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM precio_zona_extendida";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPrecioZonaExtendidaById($id_precio_zona_extendida)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM precio_zona_extendida WHERE id_precio_zona_extendida = :id_precio_zona_extendida";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_precio_zona_extendida", $id_precio_zona_extendida, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPrecioZonaExtendidaByNombre($nombre_paqueteria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM precio_zona_extendida WHERE nombre_paqueteria = :nombre_paqueteria";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":nombre_paqueteria", $nombre_paqueteria);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddPrecioZonaExtendida($nombre_paqueteria, $nombre_odoo, $precio, $id_precio_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO precio_zona_extendida (nombre_paqueteria, nombre_odoo, precio, id_precio_odoo) VALUES (:nombre_paqueteria, :nombre_odoo, :precio, :id_precio_odoo)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":nombre_paqueteria", $nombre_paqueteria);
        $stmt->bindParam(":nombre_odoo", $nombre_odoo);
        $stmt->bindParam(":precio", $precio);
        $stmt->bindParam(":id_precio_odoo", $id_precio_odoo, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdatePrecioZonaExtendida($id_precio_zona_extendida, $nombre_paqueteria, $nombre_odoo, $precio, $id_precio_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE precio_zona_extendida SET nombre_paqueteria = :nombre_paqueteria, nombre_odoo = :nombre_odoo, precio = :precio, id_precio_odoo = :id_precio_odoo WHERE id_precio_zona_extendida = :id_precio_zona_extendida";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":nombre_paqueteria", $nombre_paqueteria);
        $stmt->bindParam(":nombre_odoo", $nombre_odoo);
        $stmt->bindParam(":precio", $precio);
        $stmt->bindParam(":id_precio_odoo", $id_precio_odoo, PDO::PARAM_INT);
        $stmt->bindParam(":id_precio_zona_extendida", $id_precio_zona_extendida, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeletePrecioZonaExtendida($id_precio_zona_extendida)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM precio_zona_extendida WHERE id_precio_zona_extendida = :id_precio_zona_extendida";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_precio_zona_extendida", $id_precio_zona_extendida, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}