<?php

require_once "conexion.php";

class PermisoUsuario
{

    public static function mdlGetPermisoByUsuario($id_usuario)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql =
            "SELECT * 
        FROM permiso_usuario left join modulo_permiso on permiso_usuario.id_modulo_permiso = modulo_permiso.id_modulo_permiso 
        WHERE permiso_usuario.id_usuario = :id_usuario and permiso_usuario.activo = 1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPermisos()
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql = "SELECT * FROM modulo_permiso";

        $stmt = $db->prepare($sql);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddPermisoUsuario($id_usuario, $id_modulo_permiso)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql = "INSERT INTO permiso_usuario (id_usuario, id_modulo_permiso, activo) VALUES (:id_usuario, :id_modulo_permiso, 1)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_modulo_permiso", $id_modulo_permiso);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->execute();

        $lastId = $db->lastInsertId();

        $response = ($stmt->rowCount() > 0) ? $lastId : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdatePermisoUsuario($id_usuario, $id_modulo_permiso, $tipoPermiso, $value)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql = "UPDATE permiso_usuario SET " . $tipoPermiso . " = :tipo_permiso WHERE id_usuario = :id_usuario and id_modulo_permiso = :id_modulo_permiso";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->bindParam(":tipo_permiso", $value);
        $stmt->bindParam(":id_modulo_permiso", $id_modulo_permiso);
        $stmt->execute();

        $response = ($stmt) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlExistPermisoUsuario($id_usuario, $id_modulo_permiso)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql = "SELECT * FROM permiso_usuario WHERE id_usuario = :id_usuario and id_modulo_permiso = :id_modulo_permiso and activo = 1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->bindParam(":id_modulo_permiso", $id_modulo_permiso);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlSetFalsePermisosUsuario($id_usuario)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql = "UPDATE permiso_usuario SET leer = 0, escribir = 0, editar = 0, eliminar = 0 WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->execute();

        $response = ($stmt) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDesactivarPermisosUsuario($id_usuario)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();
        $sql = "UPDATE permiso_usuario SET activo = 0 WHERE id_usuario = :id_usuario";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->execute();
        $respuesta = ($stmt->rowCount() > 0) ? true : false;
        $db = null;
        return $respuesta;
    }

    public static function mdlGetPermisosByUsuarioAndPermiso($id_usuario, $id_modulo_permiso)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sql = "SELECT * FROM permiso_usuario WHERE id_usuario = :id_usuario and id_modulo_permiso = :id_modulo_permiso";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->bindParam(":id_modulo_permiso", $id_modulo_permiso);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}
