<?php

require_once 'conexion.php';

class Paqueteria
{
    public static function mdlGetPaqueterias($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM paqueteria WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddPaqueteria($nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO paqueteria (nombre, descripcion) VALUES (:nombre, :descripcion)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdatePaqueteria($id_paqueteria, $nombre, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE paqueteria SET nombre = :nombre, descripcion = :descripcion, activo = :activo WHERE id_paqueteria = :id_paqueteria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeletePaqueteria($id_paqueteria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM paqueteria WHERE id_paqueteria = :id_paqueteria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_paqueteria", $id_paqueteria);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoPaqueteria($id_paqueteria, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "UPDATE paqueteria SET activo = :activo WHERE id_paqueteria = :id_paqueteria";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
        $stmt->bindParam(':id_paqueteria', $id_paqueteria, PDO::PARAM_INT);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPaqueteriaByNombre($nombre)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM paqueteria WHERE nombre = :nombre AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPaqueteriaById($id_paqueteria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM paqueteria WHERE id_paqueteria = :id_paqueteria AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}