<?php

require_once 'conexion.php';

class Pago
{
    public static function mdlGetPagos($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM pago WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetPagoByIdOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM pago WHERE id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddPago($id_orden, $id_transaccion, $pasarela_pago, $metodo_pago, $moneda, $cantidad_pago, $nombre_comprador, $estado_pago, $user_agent, $ip)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO pago (id_orden, id_transaccion, pasarela_pago, metodo_pago, moneda, cantidad_pago, nombre_comprador, estado_pago, user_agent, ip) VALUES (:id_orden, :id_transaccion, :pasarela_pago, :metodo_pago, :moneda, :cantidad_pago, :nombre_comprador, :estado_pago, :user_agent, :ip)";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden);
        $stmt->bindParam(":id_transaccion", $id_transaccion);
        $stmt->bindParam(":pasarela_pago", $pasarela_pago);
        $stmt->bindParam(":metodo_pago", $metodo_pago);
        $stmt->bindParam(":moneda", $moneda);
        $stmt->bindParam(":cantidad_pago", $cantidad_pago);
        $stmt->bindParam(":nombre_comprador", $nombre_comprador);
        $stmt->bindParam(":estado_pago", $estado_pago);
        $stmt->bindParam(":user_agent", $user_agent);
        $stmt->bindParam(":ip", $ip);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlGetTotalIngresosEntreFechas($fecha_inicial, $fecha_final)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT SUM(cantidad_pago) as total FROM pago WHERE DATE(fecha_pago) BETWEEN :fecha_inicial AND :fecha_final";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":fecha_inicial", $fecha_inicial);
        $stmt->bindParam(":fecha_final", $fecha_final);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
