<?php

require_once 'conexion.php';

class Orden
{
    public static function mdlGetOrdenesByIdUsuario($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT orden.*, pago.cantidad_pago, pago.metodo_pago, estado_orden.id_estado_orden, estado_orden.nombre AS estado_orden
                FROM orden 
                LEFT JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden 
                LEFT JOIN pago ON orden.id_orden = pago.id_orden
                WHERE id_usuario = :id_usuario ORDER BY orden.fecha_alta DESC";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetOrdenesByIdUsuarioLimit($id_usuario, $limit)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT orden.*, estado_orden.id_estado_orden, estado_orden.nombre AS estado_orden
                FROM orden LEFT JOIN estado_orden 
                ON orden.id_estado_orden = estado_orden.id_estado_orden 
                WHERE id_usuario = :id_usuario ORDER BY orden.fecha_alta DESC LIMIT :limit";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":limit", $limit, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetUltimasOrdenesLimit($limit)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql =
            "SELECT orden.*, estado_orden.id_estado_orden, estado_orden.nombre AS nombre_estado_orden, pago.cantidad_pago as cantidad_pago_pasarela, usuario.nombre as nombre_usuario, usuario.apellido_paterno as apellido_paterno_usuario, usuario.apellido_materno as apellido_materno_usuario
            
            FROM orden LEFT JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden 
                LEFT JOIN pago ON orden.id_orden = pago.id_orden
                LEFT JOIN usuario ON orden.id_usuario = usuario.id_usuario
            
            ORDER BY orden.fecha_alta DESC LIMIT :limit";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":limit", $limit, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDetallesOrden($id_usuario, $id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT orden.*, estado_orden.id_estado_orden, estado_orden.nombre AS estado_orden
                FROM orden LEFT JOIN estado_orden 
                ON orden.id_estado_orden = estado_orden.id_estado_orden 
                WHERE id_usuario = :id_usuario AND id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDetallesOrdenByNumeroOrden($id_usuario, $numero_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT orden.*, pago.cantidad_pago, pago.metodo_pago, estado_orden.id_estado_orden, estado_orden.nombre AS estado_orden
                FROM orden LEFT JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden 
                LEFT JOIN pago ON orden.id_orden = pago.id_orden
                WHERE id_usuario = :id_usuario AND numero_orden = :numero_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":numero_orden", $numero_orden, PDO::PARAM_STR);
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddOrden($numero_orden, $id_usuario, $id_direccion_envio, $id_direccion_facturacion, $id_orden_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO orden (numero_orden, id_usuario, id_direccion_envio, id_direccion_facturacion, id_orden_odoo) 
            VALUES (:numero_orden, :id_usuario, :id_direccion_envio, :id_direccion_facturacion, :id_orden_odoo)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":numero_orden", $numero_orden);
        $stmt->bindParam(":id_usuario", $id_usuario);
        $stmt->bindParam(":id_direccion_envio", $id_direccion_envio);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion);
        $stmt->bindParam(":id_orden_odoo", $id_orden_odoo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateEstadoOrden($id_orden, $id_estado_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE orden SET id_estado_orden = :id_estado_orden WHERE id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_estado_orden", $id_estado_orden, PDO::PARAM_INT);
        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateOrden($id_orden, $id_usuario, $id_direccion_envio, $id_direccion_facturacion, $id_estado_orden, $id_orden_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE orden SET id_usuario = :id_usuario, id_direccion_envio = :id_direccion_envio, id_direccion_facturacion = :id_direccion_facturacion, id_estado_orden = :id_estado_orden, id_orden_odoo = :id_orden_odoo WHERE id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion_envio", $id_direccion_envio, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion_facturacion", $id_direccion_facturacion, PDO::PARAM_INT);
        $stmt->bindParam(":id_estado_orden", $id_estado_orden, PDO::PARAM_INT);
        $stmt->bindParam(":id_orden_odoo", $id_orden_odoo, PDO::PARAM_STR);
        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM orden WHERE id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlVerifyNumeroOrden($numero_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM orden WHERE numero_orden = :numero_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":numero_orden", $numero_orden, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlSearchLimit($filtros, $terminoBusqueda, $orden, $offset, $limit)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();
        $sqlOrden = '';

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado_orden") {
                    $sqlFiltro .= "orden.id_estado_orden = " . $filtro['data']['id_estado_orden'];
                }

                if ($campo == "almacen") {
                    $sqlFiltro .= "producto_orden.id_almacen_odoo = " . $filtro['data']['id_almacen_odoo'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(orden.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(orden.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND orden.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "orden.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "orden.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "orden.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "orden.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno) LIKE ? OR 
                usuario.nombre LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? OR
                orden.numero_orden LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        if ($orden != NULL) {
            // AQUI VA EL QUERY PARA EL TERMINO DE LA ORDEN
            if ($orden['campo'] == 'nombre')
                $sqlOrden .= ' ORDER BY usuario.nombre ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_alta')
                $sqlOrden .= ' ORDER BY orden.fecha_alta ' . $orden['orden'];
            if ($orden['campo'] == 'total')
                $sqlOrden .= ' ORDER BY pago.cantidad_pago ' . $orden['orden'];
        } else {
            $sqlOrden .= ' ORDER BY orden.id_orden DESC';
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT DISTINCT orden.*, estado_orden.id_estado_orden, estado_orden.nombre AS nombre_estado_orden, pago.cantidad_pago as cantidad_pago_pasarela, usuario.nombre as nombre_usuario, usuario.apellido_paterno as apellido_paterno_usuario, usuario.apellido_materno as apellido_materno_usuario
                    FROM orden LEFT JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden 
                    LEFT JOIN pago ON orden.id_orden = pago.id_orden
                    LEFT JOIN usuario ON orden.id_usuario = usuario.id_usuario
                    LEFT JOIN producto_orden ON orden.id_orden = producto_orden.id_orden
                    LEFT JOIN producto ON producto_orden.id_producto = producto.id_producto
                 " . $sqlTotal . " " . $sqlOrden . " LIMIT " . $offset . ", " . $limit;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlSearchTotal($filtros, $terminoBusqueda)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado_orden") {
                    $sqlFiltro .= "orden.id_estado_orden = " . $filtro['data']['id_estado_orden'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(orden.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(orden.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND orden.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "orden.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "orden.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "orden.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "orden.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno) LIKE ? OR 
                usuario.nombre LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? OR
                orden.numero_orden LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT COUNT(*) as total
            FROM (
                SELECT DISTINCT orden.id_orden
                FROM orden
                LEFT JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden 
                LEFT JOIN pago ON orden.id_orden = pago.id_orden
                LEFT JOIN usuario ON orden.id_usuario = usuario.id_usuario
                LEFT JOIN producto_orden ON orden.id_orden = producto_orden.id_orden
                LEFT JOIN producto ON producto_orden.id_producto = producto.id_producto
                " . $sqlTotal . "
            ) as subquery";
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlGetTotalOrdenesEntreFechas($fecha_inicial, $fecha_final)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT COUNT(*) as total FROM orden WHERE DATE(fecha_alta) BETWEEN :fecha_inicial AND :fecha_final";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":fecha_inicial", $fecha_inicial);
        $stmt->bindParam(":fecha_final", $fecha_final);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetOrdenById($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT orden.*, estado_orden.nombre AS estado_orden, pago.cantidad_pago, pago.metodo_pago, pago.id_transaccion, usuario.nombre as nombre_usuario, usuario.apellido_paterno as apellido_paterno_usuario, usuario.apellido_materno as apellido_materno_usuario, usuario.correo as correo_usuario 
                FROM orden 
                LEFT JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden
                LEFT JOIN pago ON orden.id_orden = pago.id_orden
                LEFT JOIN usuario ON orden.id_usuario = usuario.id_usuario
            WHERE orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetIdOrdenOdooById($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT orden.id_orden_odoo FROM orden WHERE orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetProductosOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_orden.*, producto.nombre, producto.sku, producto.imagenes, categoria.color as color_categoria, producto_orden.cantidad, producto_orden.id_precio, precio.precio as precio_producto, producto_orden.id_almacen_odoo, almacenes_odoo.nombre_almacen 
                FROM producto_orden 
                LEFT JOIN producto ON producto_orden.id_producto = producto.id_producto
                inner join producto_categoria on producto.id_producto = producto_categoria.id_producto
                inner join categoria on producto_categoria.id_categoria = categoria.id_categoria
                LEFT JOIN precio ON producto_orden.id_precio = precio.id_precio
                LEFT JOIN almacenes_odoo ON producto_orden.id_almacen_odoo = almacenes_odoo.id_odoo
                WHERE producto_orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetGuiaProducto($id_producto_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT guia_envio_orden.numero_rastreo, guia_envio_producto.nombre as nombre_paqueteria
            FROM guia_producto_orden 
                left join guia_envio_orden on guia_envio_orden.id_guia_envio_orden = guia_producto_orden.id_guia_envio_orden
                left join guia_envio_producto on guia_envio_orden.id_guia_envio_producto = guia_envio_producto.id_guia_envio_producto

            WHERE guia_producto_orden.id_producto_orden = :id_producto_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto_orden", $id_producto_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetGuiasOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT guia_envio_orden.*, precio.precio, guia_envio_producto.nombre as nombre_paqueteria 
            FROM guia_envio_orden 
                left join guia_envio_producto on guia_envio_orden.id_guia_envio_producto = guia_envio_producto.id_guia_envio_producto
                left join precio on guia_envio_producto.id_precio = precio.id_precio
            WHERE id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetProductosGuia($id_guia_envio_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_orden.*, producto.nombre, producto.sku, producto.imagenes, categoria.color as color_categoria, producto_orden.cantidad, producto_orden.id_precio, precio.precio as precio_producto, producto_orden.id_almacen_odoo, almacenes_odoo.nombre_almacen 
                FROM guia_producto_orden left join producto_orden on guia_producto_orden.id_producto_orden = producto_orden.id_producto_orden
                LEFT JOIN producto ON producto_orden.id_producto = producto.id_producto
                inner join producto_categoria on producto.id_producto = producto_categoria.id_producto
                inner join categoria on producto_categoria.id_categoria = categoria.id_categoria
                LEFT JOIN precio ON producto_orden.id_precio = precio.id_precio
                LEFT JOIN almacenes_odoo ON producto_orden.id_almacen_odoo = almacenes_odoo.id_odoo
                WHERE guia_producto_orden.id_guia_envio_orden = :id_guia_envio_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_guia_envio_orden", $id_guia_envio_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
