<?php

require_once 'odoo_auth.php';

class OdooProducto
{

    public static function searchProductoPorTerminoBusquedaTotal($search_term, $tag_id){
        try {
            $models = OdooAuth::getOdoo();

            // Debe buscar por 'name' y por 'default_code'
            if(is_null($search_term)){
                $array = array(
                    array('product_tag_ids', 'in', $tag_id), // Filtra por tag_id
                );
            } else {
                $array = array(
                    '&', // Operador AND
                    array('product_tag_ids', 'in', $tag_id), // Filtra por tag_id
                    '|', // Operador OR
                    array('name', 'ilike', $search_term), // Busca por nombre
                    array('default_code', 'ilike', $search_term) // Busca por código
                );
            }
            
            $total_productos = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_count',
                array(
                    $array
                ),
            );

            return $total_productos;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function searchProductoPorTerminoBusquedaLimit($search_term, $tag_id, $offset = 0, $limit = 10){
        try {
            $models = OdooAuth::getOdoo();

            if(is_null($search_term)){
                $array = array(
                    array('product_tag_ids', 'in', $tag_id), // Filtra por tag_id
                );
            } else {
                // Debe buscar por 'name' y por 'default_code'
                $array = array(
                    '&', // Operador AND
                    array('product_tag_ids', 'in', $tag_id), // Filtra por tag_id
                    '|', // Operador OR
                    array('name', 'ilike', $search_term), // Busca por nombre
                    array('default_code', 'ilike', $search_term) // Busca por código
                );
            }
            
            $productos = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_read',
                array(
                    $array
                ),
                array(
                    'fields' => array(
                        'id',
                        'default_code',
                        'name',
                        'weight',
                        'weight_uom_name',
                        'volume',
                        'volume_uom_name',
                        'list_price',
                        'product_length',
                        'product_height',
                        'product_width'
                    ),
                    'offset' => $offset, // Offset para la paginación
                    'limit' => $limit, // Límite para la paginación
                    'order' => 'create_date DESC'
                )
            );

            return $productos;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }


    public static function searchProductoPorNombreLimit($nombre, $tag_id, $offset = 0, $limit = 10)
    {
        try {
            $models = OdooAuth::getOdoo();

            $productos = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_read',
                array(
                    array(
                        array('product_tag_ids', 'in', $tag_id), // Filtra por tag_id
                        array('name', 'ilike', $nombre) // Busca por nombre
                    )
                ),
                array(
                    'fields' => array(
                        'id',
                        'default_code',
                        'name',
                        'weight',
                        'weight_uom_name',
                        'volume',
                        'volume_uom_name',
                        'list_price'
                    ),
                    'offset' => $offset, // Offset para la paginación
                    'limit' => $limit, // Límite para la paginación
                )
            );

            return $productos;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getTotalProductosOdoo($tag_id)
    {
        try {
            $models = OdooAuth::getOdoo();

            $totalProductos = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_count',
                array(
                    array(
                        array('product_tag_ids', 'in', $tag_id) // Usa el ID obtenido para filtrar los productos
                    )
                )
            );

            return $totalProductos;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getProductosOdooLimit($offset = 0, $limit = 10, $tag_id)
    {
        try {
            $models = OdooAuth::getOdoo();

            $productos = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_read',
                array(
                    array(
                        array('product_tag_ids', 'in', $tag_id) // Usa el ID obtenido para filtrar los productos
                    )
                ),
                array(
                    'fields' => array(
                        'id',
                        'default_code',
                        'name',
                        'weight',
                        'weight_uom_name',
                        'volume',
                        'volume_uom_name',
                        'list_price'
                    ),
                    'limit' => $limit,
                    'offset' => $offset,
                    'order' => 'create_date DESC'
                )
            );

            return $productos;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function searchProducts($tag_id)
    {
        try {
            $models = OdooAuth::getOdoo();

            $products = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_read',
                array(
                    array(
                        array('product_tag_ids', 'in', $tag_id) // Usa el ID obtenido para filtrar los productos
                    )
                ),
                array(
                    'fields' => array(
                        'name',
                        'list_price',
                        'standard_price',
                        'qty_available',
                        'virtual_available',
                        'categ_id',
                    )
                ) // estos son los campos que quieres leer
            );

            return $products;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getProductTagId($tag_name)
    {
        try {
            $models = OdooAuth::getOdoo();

            $tag_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.tag', // Asumiendo que este es el modelo de etiquetas
                'search',
                array(
                    array(
                        array('name', '=', $tag_name) // Busca el ID de la etiqueta 'versaprink'
                    )
                )
            );
            return $tag_ids;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function searchProduct($product_id)
    {
        try {
            $models = OdooAuth::getOdoo();

            $product = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.product',
                'search_read',
                array(
                    array(
                        array('id', '=', $product_id) // Filter products by ID
                    )
                ),
                array(
                    'fields' => array(
                        'name',
                        'list_price',
                        'standard_price',
                        'qty_available',
                        'free_qty',
                        'virtual_available',
                        'categ_id',

                        'weight',
                        'weight_uom_name',
                        'volume',
                        'volume_uom_name',
                        'product_length',
                        'product_height',
                        'product_width'
                    )
                )
            );

            return $product;
        } catch (Exception $e) {
            // Error handling
            error_log($e->getMessage());
            return false;
        }
    }
}
