<?php

require_once 'odoo_auth.php';

class OdooListaPrecio
{

    public static function getListasPreciosAsociadasAProducto($product_id){
        $models = OdooAuth::getOdoo();
        // Obtener los ID de las listas de precios asociadas al producto
        // $pricelist_ids = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.pricelist',
        //     'search',
        //     array(
        //         array()
        //     )
        // );

        // $pricelists = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.pricelist',
        //     'read',
        //     array(
        //         $pricelist_ids
        //     ),
        //     array('fields' => array('name', 'currency_id'))
        // );

        // // $pricelist_id = 7; // ID de la lista de precios que quieres utilizar
        // // $product_tmpl_id = 11; // ID del producto para el cual quieres obtener el precio
        // // $product_id = 17; // ID del producto para el cual quieres obtener el precio

        // Obtener el precio base del producto
        // $product_data = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.product',
        //     'read',
        //     array(
        //         array($product_id)
        //     ),
        //     array('fields' => array('list_price')) // Precio base del producto
        // );

        // $final_price = $product_data[0]['list_price'];

        // // Obtener las reglas de la lista de precios
        // $pricelist_rules = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.pricelist.item',
        //     'search_read',
        //     array(
        //         array(
        //             array('pricelist_id', '=', $pricelist_id),
        //             array('applied_on', '=', '0_product_variant'), // Asegúrate de ajustar este filtro según tus necesidades
        //         )
        //     ),
        //     array('fields' => array('compute_price', 'fixed_price', 'percent_price', 'price_discount', 'price_surcharge'))
        // );

        // // Aplica las reglas al precio base del producto
        // foreach ($pricelist_rules as $rule) {
        //     // Implementa aquí la lógica para aplicar la regla al precio base
        //     // Por ejemplo:
        //     if ($rule['compute_price'] == 'fixed') {
        //         $final_price = $rule['fixed_price'];
        //     } elseif ($rule['compute_price'] == 'percentage') {
        //         $final_price *= (1 + $rule['percent_price'] / 100);
        //     }
        //     // ... otros casos según las reglas de tu pricelist
        // }


        // TERCER INTENTO
        // Obtener el precio del producto usando la lista de precios
        // $product_price = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.pricelist',
        //     'get_product_price',
        //     array(
        //         $pricelist_id,
        //         $product_id,
        //         1 // La cantidad del producto, puedes ajustarla según sea necesario
        //     )
        // );

        // Obtener el precio base del producto
        // $product_data = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.product',
        //     'read',
        //     array(
        //         array($product_id)
        //     ),
        //     array('fields' => array('list_price')) // Precio base del producto
        // );

        // $final_price = $product_data[0]['list_price'];

        // Obtener las reglas de la lista de precios
        // $pricelist_rules = $models->execute_kw(
        //     OdooAuth::$db,
        //     OdooAuth::$uid,
        //     OdooAuth::$password,
        //     'product.pricelist.item',
        //     'search_read',
        //     array(
        //         // array(
        //         //     // array('pricelist_id', '=', $pricelist_id),
        //         //     // array('applied_on', '=', '0_product_variant'), // Asegúrate de ajustar este filtro según tus necesidades
        //         // )
        //     )
        //     // array('fields' => array('applied_on', 'compute_price', 'fixed_price', 'percent_price', 'price_discount', 'price_surcharge', 'min_quantity'))
        // );


        // CUARTO INTENTO
        // Obtener los registros de la lista de precios que coinciden con el pricelist_id y product_tmpl_id
        $pricelist_items = $models->execute_kw(
            OdooAuth::$db,
            OdooAuth::$uid,
            OdooAuth::$password,
            'product.pricelist.item',
            'search_read',
            array(
                array(
                    // array('pricelist_id', '=', $pricelist_id),
                    array('product_id', '=', $product_id),
                    // array('product_tmpl_id', '=', $product_tmpl_id)
                )
            ),
            array('fields' => array('price', "product_id", 'pricelist_id', 'fixed_price', 'percent_price', 'price_discount', 'product_tmpl_id', 'min_quantity'))
        );

        return $pricelist_items;


    }
        
    public static function getListaPreciosByProductoId($product_id)
    {
        try{
            $models = OdooAuth::getOdoo();
    
            // Buscar ítems de lista de precios para un producto específico
            $precio_producto = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.pricelist.item', // Modelo de ítems de lista de precios
                'search_read',
                array(
                    array(
                        array('id', '=', $product_id), // Filter by ID
                    )
                ),
                array('fields' => array('id', 'price', "product_id", 'pricelist_id', 'fixed_price', 'percent_price', 'price_discount', 'product_tmpl_id', 'min_quantity')) // The fields you want to read
            );
    
            return $precio_producto;
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getPriceByProductIdAndPriceListName($product_id, $price_list_name)
    {
        try {
            $models = OdooAuth::getOdoo();

            // Buscar la lista de precios por nombre
            $pricelist_ids = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.pricelist',
                'search',
                array(
                    array(
                        array('name', '=', $price_list_name)
                    )
                )
            );

            if (empty($pricelist_ids)) {
                return "Lista de precios no encontrada.";
            }

            // Buscar el precio del producto en la lista de precios
            $price_items = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.pricelist.item',
                'search_read',
                array(
                    array(
                        array('pricelist_id', '=', $pricelist_ids[0]),
                        array('product_id', '=', $product_id)
                    )
                ),
                array('fields' => array('fixed_price')) // Campo con el precio fijo
            );

            if (empty($price_items)) {
                return "Precio no encontrado en la lista de precios.";
            }

            return $price_items[0]['fixed_price']; // Retorna el precio encontrado
        } catch (Exception $e) {
            // Manejo del error
            error_log($e->getMessage());
            return false;
        }
    }

    public static function getPriceRulesByProductId($product_id)
    {
        try {
            $models = OdooAuth::getOdoo();

            $price_rules = $models->execute_kw(
                OdooAuth::$db,
                OdooAuth::$uid,
                OdooAuth::$password,
                'product.pricelist.item', // The model that stores price rules
                'search_read',
                array(
                    array(
                        array('product_tmpl_id', '=', array($product_id, false)),
                    )
                ),
                array('fields' => array('id', 'price', 'product_id', 'pricelist_id', 'fixed_price', 'percent_price', 'price_discount', 'product_tmpl_id', 'min_quantity')) // The fields you want to read
            );
            return $price_rules;
        } catch (Exception $e) {
            // Error handling
            error_log($e->getMessage());
            return false;
        }
    }

}
