<?php

require_once 'conexion.php';

class MaterialExtra
{
    public static function mdlAddMaterialExtra($id_producto, $url_pdf, $nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO material_extra (id_producto, url_pdf, nombre, descripcion) VALUES (:id_producto, :url_pdf, :nombre, :descripcion)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(':url_pdf', $url_pdf, PDO::PARAM_STR);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddDescargaMaterialExtra($id_material_extra)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE material_extra SET descargas = descargas + 1 WHERE id_material_extra = :id_material_extra";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_material_extra', $id_material_extra, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
    
    public static function mdlGetMaterialExtra($id_material_extra)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM material_extra WHERE id_material_extra = :id_material_extra";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_material_extra', $id_material_extra, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetMaterialExtras($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM material_extra WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetAllMaterialExtras()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM material_extra ORDER BY id_material_extra DESC";
        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        $stmt = null;

        return $response;
    }

    public static function mdlUpdateMaterialExtra($id_material_extra, $id_producto, $url_pdf, $nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE material_extra SET id_producto = :id_producto, url_pdf = :url_pdf, nombre = :nombre, descripcion = :descripcion WHERE id_material_extra = :id_material_extra";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_material_extra', $id_material_extra, PDO::PARAM_INT);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(':url_pdf', $url_pdf, PDO::PARAM_STR);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateNombreYDescripcion($id_material_extra, $nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE material_extra SET nombre = :nombre, descripcion = :descripcion WHERE id_material_extra = :id_material_extra";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_material_extra', $id_material_extra, PDO::PARAM_INT);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;
        $stmt = null;
        return $response;
    }

    public static function mdlUpdateEstadoMaterialExtra($id_material_extra, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE material_extra SET activo = :activo WHERE id_material_extra = :id_material_extra";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_material_extra', $id_material_extra, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteMaterialExtra($id_material_extra)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM material_extra WHERE id_material_extra = :id_material_extra";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_material_extra', $id_material_extra, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetMaterialesExtraByIdProducto($id_producto){
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM material_extra WHERE id_producto = :id_producto";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_producto', $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}
