<?php

require_once 'conexion.php';

class Marca
{
    public static function mdlAddMarca($nombre_marca)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO marca (nombre_marca) VALUES (:nombre_marca)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nombre_marca', $nombre_marca, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetMarca($id_marca)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM marca WHERE id_marca = :id_marca";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_marca', $id_marca, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetMarcas($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM marca WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateMarca($id_marca, $nombre_marca, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE marca SET nombre_marca = :nombre_marca, activo = :activo WHERE id_marca = :id_marca";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_marca', $id_marca, PDO::PARAM_INT);
        $stmt->bindParam(':nombre_marca', $nombre_marca, PDO::PARAM_STR);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoMarca($id_marca, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE marca SET activo = :activo WHERE id_marca = :id_marca";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_marca', $id_marca, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteMarca($id_marca)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM marca WHERE id_marca = :id_marca";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_marca', $id_marca, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}