<?php

require_once 'conexion.php';

class GuiaEnvioZonaExtendidaProducto
{
    public static function mdlGetGuiaEnvioZonaExtendidaProductoByIdCostoOdoo($id_costo_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT id_guia_envio_zona_extendida_producto FROM guia_envio_zona_extendida_producto WHERE id_costo_odoo = :id_costo_odoo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_costo_odoo", $id_costo_odoo);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdllGetGuiaEnvioZonaExtendidaProductoById($id_guia_envio_zona_extendida_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT guia_envio_zona_extendida_producto.*, precio.precio 
                FROM guia_envio_zona_extendida_producto INNER JOIN precio ON guia_envio_zona_extendida_producto.id_precio = precio.id_precio
                WHERE id_guia_envio_zona_extendida_producto = :id_guia_envio_zona_extendida_producto";

        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_guia_envio_zona_extendida_producto", $id_guia_envio_zona_extendida_producto);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}