<?php

require_once 'conexion.php';

class GuiaEnvioOrden
{
    public static function mdlAddGuiaEnvioOrden($id_guia_envio_producto, $id_orden, $numero_rastreo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO guia_envio_orden (id_guia_envio_producto, id_orden, numero_rastreo) 
                VALUES (:id_guia_envio_producto, :id_orden, :numero_rastreo)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_guia_envio_producto", $id_guia_envio_producto);
        $stmt->bindParam(":id_orden", $id_orden);
        $stmt->bindParam(":numero_rastreo", $numero_rastreo);
        
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetGuiaEnvioOrdenByIdOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM guia_envio_orden WHERE id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;

    }
}