<?php

require_once 'conexion.php';

class FormularioContacto
{
    public static function mdlGetFormulariosContacto($visto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM formulario_contacto WHERE visto = :visto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":visto", $visto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetFormularioContactoById($id_formulario_contacto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM formulario_contacto WHERE id_formulario_contacto = :id_formulario_contacto";

        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_formulario_contacto", $id_formulario_contacto, PDO::PARAM_INT);
       
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddFormularioContacto($id_usuario, $id_producto, $nombre, $correo, $mensaje)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO formulario_contacto (id_usuario, id_producto, nombre, correo, mensaje) VALUES (:id_usuario, :id_producto, :nombre, :correo, :mensaje)";

        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":correo", $correo);
        $stmt->bindParam(":mensaje", $mensaje);
        
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateFormularioContacto($id_formulario_contacto, $id_usuario, $id_producto, $nombre, $correo, $telefono, $mensaje, $visto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE formulario_contacto SET id_usuario = :id_usuario, id_producto = :id_producto, nombre = :nombre, correo = :correo, telefono = :telefono, mensaje = :mensaje, visto = :visto WHERE id_formulario_contacto = :id_formulario_contacto";

        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":correo", $correo);
        $stmt->bindParam(":telefono", $telefono);
        $stmt->bindParam(":mensaje", $mensaje);
        $stmt->bindParam(":visto", $visto, PDO::PARAM_INT);
        $stmt->bindParam(":id_formulario_contacto", $id_formulario_contacto, PDO::PARAM_INT);
        
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateVistoFormularioContacto($id_formulario_contacto,$visto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE formulario_contacto SET visto = :visto WHERE id_formulario_contacto = :id_formulario_contacto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_formulario_contacto", $id_formulario_contacto, PDO::PARAM_INT);
        $stmt->bindParam(":visto", $visto, PDO::PARAM_INT);
        
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteFormularioContacto($id_formulario_contacto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM formulario_contacto WHERE id_formulario_contacto = :id_formulario_contacto";

        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_formulario_contacto", $id_formulario_contacto, PDO::PARAM_INT);
        
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}