<?php

require_once 'conexion.php';

class Faq
{
    public static function mdlAddFaq($pregunta, $respuesta, $visitas, $predeterminada)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO faq (pregunta, respuesta, visitas, predeterminada) VALUES (:pregunta, :respuesta, :visitas, :predeterminada)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':pregunta', $pregunta, PDO::PARAM_STR);
        $stmt->bindParam(':respuesta', $respuesta, PDO::PARAM_STR);
        $stmt->bindParam(':visitas', $visitas, PDO::PARAM_INT);
        $stmt->bindParam(':predeterminada', $predeterminada, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddVisitasFaq($id_faq)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE faq SET visitas = visitas + 1 WHERE id_faq = :id_faq";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_faq', $id_faq, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
    
    public static function mdlGetFaq($id_faq)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM faq WHERE id_faq = :id_faq";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_faq', $id_faq, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetFaqs($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM faq WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetAllFaqs()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM faq ORDER BY id_faq DESC";
        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        $stmt = null;

        return $response;
    }

    public static function mdlUpdateFaq($id_faq, $pregunta, $respuesta, $visitas, $predeterminada, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE faq SET pregunta = :pregunta, respuesta = :respuesta, visitas = :visitas, predeterminada = :predeterminada, activo = :activo WHERE id_faq = :id_faq";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_faq', $id_faq, PDO::PARAM_INT);
        $stmt->bindParam(':pregunta', $pregunta, PDO::PARAM_STR);
        $stmt->bindParam(':respuesta', $respuesta, PDO::PARAM_STR);
        $stmt->bindParam(':visitas', $visitas, PDO::PARAM_INT);
        $stmt->bindParam(':predeterminada', $predeterminada, PDO::PARAM_BOOL);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdatePreguntaYRespuesta($id_faq, $pregunta, $respuesta)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE faq SET pregunta = :pregunta, respuesta = :respuesta WHERE id_faq = :id_faq";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_faq', $id_faq, PDO::PARAM_INT);
        $stmt->bindParam(':pregunta', $pregunta, PDO::PARAM_STR);
        $stmt->bindParam(':respuesta', $respuesta, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;
        $stmt = null;
        return $response;
    }

    public static function mdlUpdateEstadoFaq($id_faq, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE faq SET activo = :activo WHERE id_faq = :id_faq";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_faq', $id_faq, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteFaq($id_faq)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM faq WHERE id_faq = :id_faq";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_faq', $id_faq, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
