<?php

require_once 'conexion.php';

class EstadoCita
{
    public static function mdlAddEstadoCita($nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO estado_cita (nombre, descripcion) VALUES (:nombre, :descripcion)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetEstadoCita($id_estado_cita)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM estado_cita WHERE id_estado_cita = :id_estado_cita";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_cita', $id_estado_cita, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetEstadosCita($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM estado_cita WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoCita($id_estado_cita, $nombre, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE estado_cita SET nombre = :nombre, descripcion = :descripcion, activo = :activo WHERE id_estado_cita = :id_estado_cita";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_cita', $id_estado_cita, PDO::PARAM_INT);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoEstadoCita($id_estado_cita, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE estado_cita SET activo = :activo WHERE id_estado_cita = :id_estado_cita";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_cita', $id_estado_cita, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteEstadoCita($id_estado_cita)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM estado_cita WHERE id_estado_cita = :id_estado_cita";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_cita', $id_estado_cita, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
