<?php

require_once 'conexion.php';

class DireccionesSEPOMEX
{
    public static function mdlAddDireccionSEPOMEX(
        $d_codigo,
        $d_asenta,
        $d_tipo_asenta,
        $d_mnpio,
        $d_estado,
        $d_cp,
        $c_estado,
        $c_oficina,
        $c_cp,
        $c_tipo_asenta,
        $c_mnpio,
        $id_asenta_cpcons,
        $d_zona,
        $c_cve_ciudad
    ) {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO direcciones_sepomex (
            d_codigo, d_asenta, d_tipo_asenta, d_mnpio, d_estado, d_cp, 
            c_estado, c_oficina, c_cp, c_tipo_asenta, c_mnpio, 
            id_asenta_cpcons, d_zona, c_cve_ciudad
        ) VALUES (
            :d_codigo, :d_asenta, :d_tipo_asenta, :d_mnpio, :d_estado, :d_cp, 
            :c_estado, :c_oficina, :c_cp, :c_tipo_asenta, :c_mnpio, 
            :id_asenta_cpcons, :d_zona, :c_cve_ciudad
        )";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":d_codigo", $d_codigo, PDO::PARAM_STR);
        $stmt->bindParam(":d_asenta", $d_asenta, PDO::PARAM_STR);
        $stmt->bindParam(":d_tipo_asenta", $d_tipo_asenta, PDO::PARAM_STR);
        $stmt->bindParam(":d_mnpio", $d_mnpio, PDO::PARAM_STR);
        $stmt->bindParam(":d_estado", $d_estado, PDO::PARAM_STR);
        $stmt->bindParam(":d_cp", $d_cp, PDO::PARAM_STR);
        $stmt->bindParam(":c_estado", $c_estado, PDO::PARAM_STR);
        $stmt->bindParam(":c_oficina", $c_oficina, PDO::PARAM_STR);
        $stmt->bindParam(":c_cp", $c_cp, PDO::PARAM_STR);
        $stmt->bindParam(":c_tipo_asenta", $c_tipo_asenta, PDO::PARAM_STR);
        $stmt->bindParam(":c_mnpio", $c_mnpio, PDO::PARAM_STR);
        $stmt->bindParam(":id_asenta_cpcons", $id_asenta_cpcons, PDO::PARAM_STR);
        $stmt->bindParam(":d_zona", $d_zona, PDO::PARAM_STR);
        $stmt->bindParam(":c_cve_ciudad", $c_cve_ciudad, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetDireccionSEPOMEXByCP($cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direcciones_sepomex WHERE d_codigo = :cp";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":cp", $cp, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetDireccionSEPOMEXById($id_direccion_sepomex)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direcciones_sepomex WHERE id_direccion_sepomex = :id_direccion_sepomex";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_direccion_sepomex", $id_direccion_sepomex, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}
