<?php

require_once 'conexion.php';

class DireccionEnvio
{
    public static function mdlGetDireccionesById($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_envio WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionById($id_usuario, $id_direccion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_envio WHERE id_usuario = :id_usuario AND id_direccion_envio = :id_direccion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion", $id_direccion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddDireccion($id_usuario, $cp, $estado, $delegacion, $colonia, $calle, $numero_exterior, $numero_interior, $numero_celular, $referencia, $nombre_receptor)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO direccion_envio (id_usuario, cp, estado, delegacion, colonia, calle, numero_exterior, numero_interior, numero_celular, referencia, nombre_receptor) VALUES (:id_usuario, :cp, :estado, :delegacion, :colonia, :calle, :numero_exterior, :numero_interior, :numero_celular, :referencia, :nombre_receptor)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":cp", $cp);
        $stmt->bindParam(":estado", $estado);
        $stmt->bindParam(":delegacion", $delegacion);
        $stmt->bindParam(":colonia", $colonia);
        $stmt->bindParam(":calle", $calle);
        $stmt->bindParam(":numero_exterior", $numero_exterior);
        $stmt->bindParam(":numero_interior", $numero_interior);
        $stmt->bindParam(":numero_celular", $numero_celular);
        $stmt->bindParam(":referencia", $referencia);
        $stmt->bindParam(":nombre_receptor", $nombre_receptor);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateDireccion($id_usuario, $id_direccion, $cp, $estado, $delegacion, $colonia, $calle, $numero_exterior, $numero_interior, $numero_celular, $referencia, $nombre_receptor, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE direccion_envio SET cp = :cp, estado = :estado, delegacion = :delegacion, colonia = :colonia, calle = :calle, numero_exterior = :numero_exterior, numero_interior = :numero_interior, numero_celular = :numero_celular, referencia = :referencia, nombre_receptor = :nombre_receptor, activo = :activo WHERE id_direccion_envio = :id_direccion AND id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":cp", $cp);
        $stmt->bindParam(":estado", $estado);
        $stmt->bindParam(":delegacion", $delegacion);
        $stmt->bindParam(":colonia", $colonia);
        $stmt->bindParam(":calle", $calle);
        $stmt->bindParam(":numero_exterior", $numero_exterior);
        $stmt->bindParam(":numero_interior", $numero_interior);
        $stmt->bindParam(":numero_celular", $numero_celular);
        $stmt->bindParam(":referencia", $referencia);
        $stmt->bindParam(":nombre_receptor", $nombre_receptor);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_BOOL);
        $stmt->bindParam(":id_direccion", $id_direccion, PDO::PARAM_INT);
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteDireccion($id_usuario, $id_direccion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM direccion_envio WHERE id_usuario = :id_usuario AND id_direccion_envio = :id_direccion";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion", $id_direccion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlSetDireccionPredeterminada($id_usuario, $id_direccion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE direccion_envio SET direccion_predeterminada = CASE WHEN id_direccion_envio = :id_direccion THEN 1 ELSE 0 END WHERE id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_direccion", $id_direccion, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionPredeterminada($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM direccion_envio WHERE id_usuario = :id_usuario AND direccion_predeterminada = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateEstadoDireccionEnvio($id_usuario, $id_direccion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE direccion_envio SET activo = :activo WHERE id_direccion_envio = :id_direccion AND id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_BOOL);
        $stmt->bindParam(":id_direccion", $id_direccion, PDO::PARAM_INT);
        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetDireccionEnvioByIdOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT direccion_envio.* FROM orden left join direccion_envio on orden.id_direccion_envio = direccion_envio.id_direccion_envio WHERE orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
