<?php

require_once 'conexion.php';

class DiaInhabil
{
    public static function mdlGetDiasInhabiles()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM dia_inhabil WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddDiaInhabil($fecha, $hora_inicio, $hora_termino, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO dia_inhabil (fecha, hora_inicio, hora_termino, descripcion, activo) VALUES (:fecha, :hora_inicio, :hora_termino, :descripcion, :activo)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":fecha", $fecha);
        $stmt->bindParam(":hora_inicio", $hora_inicio);
        $stmt->bindParam(":hora_termino", $hora_termino);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateDiaInhabil($id_dia_inhabil, $fecha, $hora_inicio, $hora_termino, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE dia_inhabil SET fecha = :fecha, hora_inicio = :hora_inicio, hora_termino = :hora_termino, descripcion = :descripcion, activo = :activo WHERE id_dia_inhabil = :id_dia_inhabil";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":fecha", $fecha);
        $stmt->bindParam(":hora_inicio", $hora_inicio);
        $stmt->bindParam(":hora_termino", $hora_termino);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_dia_inhabil", $id_dia_inhabil, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteDiaInhabil($id_dia_inhabil)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM dia_inhabil WHERE id_dia_inhabil = :id_dia_inhabil";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_dia_inhabil", $id_dia_inhabil);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}