<?php

require_once 'conexion.php';

class DatosContacto{

    public static function mdlUpdateDatoContacto($nombre, $informacion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE datos_contacto SET informacion = :informacion WHERE nombre = :nombre";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(":informacion", $informacion);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->execute();
        $response = ($stmt->rowCount() > 0) ? true : false;
        $db = null;
        
        return $response;
    }
    
    public static function mdlGetAllDatosContacto()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM datos_contacto ORDER BY id_datos_contacto ASC";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        $db = null;
        
        return $response;
    }
}