<?php

require_once 'conexion.php';

class Carrito
{
    public static function mdlGetCarritoByIdUsuario($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT carrito.id_carrito, carrito.cantidad, producto.id_producto, producto.id_producto_odoo, producto.nombre, producto.imagenes, producto.url_pagina, producto.peso, producto.alto, producto.ancho, producto.largo, producto.id_precio, producto.id_precio_descuento, producto.url_pagina, precio.precio, categoria.color AS categoria_color, carrito.fecha_alta, carrito.ultima_actualizacion
                FROM carrito
                INNER JOIN producto ON carrito.id_producto = producto.id_producto
                INNER JOIN precio ON producto.id_precio = precio.id_precio
                INNER JOIN producto_categoria ON producto.id_producto = producto_categoria.id_producto
                INNER JOIN categoria ON producto_categoria.id_categoria = categoria.id_categoria
                WHERE producto.activo = 1 AND carrito.id_usuario = :id_usuario 
                ORDER BY carrito.ultima_actualizacion DESC";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCarritoByIdCarrito($id_usuario, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT carrito.*, producto.* FROM carrito
        INNER JOIN producto ON carrito.id_producto = producto.id_producto
        WHERE producto.activo = 1 AND carrito.id_usuario = :id_usuario AND producto.id_producto = :id_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddCarrito($id_usuario, $id_producto, $cantidad)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO carrito (id_usuario, id_producto, cantidad) VALUES (:id_usuario, :id_producto, :cantidad)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(":cantidad", $cantidad, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateCarrito($id_carrito, $id_usuario, $id_producto, $cantidad)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE carrito SET id_usuario = :id_usuario, id_producto = :id_producto, cantidad = :cantidad WHERE id_carrito = :id_carrito";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);
        $stmt->bindParam(":cantidad", $cantidad, PDO::PARAM_INT);
        $stmt->bindParam(":id_carrito", $id_carrito, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateCarritoProductoCantidad($id_carrito, $cantidad)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE carrito SET cantidad = :cantidad WHERE id_carrito = :id_carrito";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":cantidad", $cantidad, PDO::PARAM_INT);
        $stmt->bindParam(":id_carrito", $id_carrito, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteCarrito($id_usuario, $id_carrito)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM carrito WHERE id_usuario = :id_usuario AND id_carrito = :id_carrito";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_carrito", $id_carrito, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteCarritoByProductoUsuario($id_usuario, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM carrito WHERE id_usuario = :id_usuario AND id_producto = :id_producto";

        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteCarritoProducto($id_carrito, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM carrito WHERE id_carrito = :id_carrito AND id_producto = :id_producto";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_carrito", $id_carrito, PDO::PARAM_INT);
        $stmt->bindParam(":id_producto", $id_producto, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlObtenerCarritosAbandonados()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT carrito.id_carrito, carrito.id_usuario, carrito.id_producto, carrito.cantidad, carrito.ultima_actualizacion, producto.nombre, producto.imagenes, producto.url_pagina, precio.precio, carrito.fecha_alta FROM carrito
        INNER JOIN producto ON carrito.id_producto = producto.id_producto
        INNER JOIN precio ON producto.id_precio = precio.id_precio
        INNER JOIN precio on producto.id_precio_descuento = precio.id_precio
        INNER JOIN usuario ON carrito.id_usuario = usuario.id_usuario
        ORDER BY carrito.fecha_alta DESC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlObtenerCarritosAbandonados24Hrs()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT carrito.id_carrito, carrito.id_usuario, carrito.id_producto, carrito.cantidad, carrito.ultima_actualizacion, producto.nombre, producto.imagenes, producto.url_pagina, precio.precio FROM carrito
        INNER JOIN producto ON carrito.id_producto = producto.id_producto
        INNER JOIN precio ON producto.id_precio = precio.id_precio
        WHERE producto.activo = 1 AND carrito.ultima_actualizacion < NOW() - INTERVAL 24 HOUR ORDER BY carrito.ultima_actualizacion DESC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlSearchTotal($filtros, $terminoBusqueda)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "cantidad") {
                    $sqlFiltro .= "carrito.cantidad = " . $filtro['data']['cantidad'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(carrito.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(carrito.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND carrito.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "carrito.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "carrito.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "carrito.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "carrito.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT COUNT(*) as total 
                FROM carrito left join usuario on carrito.id_usuario = usuario.id_usuario
                left join producto on carrito.id_producto = producto.id_producto 
                inner join producto_categoria on producto.id_producto = producto_categoria.id_producto
                inner join categoria on producto_categoria.id_categoria = categoria.id_categoria
                 " . $sqlTotal;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlSearchLimit($filtros, $terminoBusqueda, $orden, $offset, $limit)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();
        $sqlOrden = '';

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "cantidad") {
                    $sqlFiltro .= "carrito.cantidad = " . $filtro['data']['cantidad'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(carrito.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(carrito.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND carrito.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "carrito.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "carrito.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "carrito.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "carrito.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        if ($orden != NULL) {
            // AQUI VA EL QUERY PARA EL TERMINO DE LA ORDEN
            if ($orden['campo'] == 'nombre')
                $sqlOrden .= ' ORDER BY usuario.nombre ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_alta')
                $sqlOrden .= ' ORDER BY carrito.fecha_alta ' . $orden['orden'];
        } else {
            $sqlOrden .= ' ORDER BY carrito.fecha_alta DESC';
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT carrito.*, usuario.nombre, usuario.apellido_paterno, usuario.apellido_materno, producto.nombre AS nombre_producto, producto.imagenes as imagenes_producto, categoria.color AS color_categoria, usuario.correo as correo_usuario, usuario.celular as celular_usuario, producto.sku as sku_producto
                FROM carrito left join usuario on carrito.id_usuario = usuario.id_usuario
                left join producto on carrito.id_producto = producto.id_producto 
                inner join producto_categoria on producto.id_producto = producto_categoria.id_producto
                inner join categoria on producto_categoria.id_categoria = categoria.id_categoria
                 " . $sqlTotal . " " . $sqlOrden . " LIMIT " . $offset . ", " . $limit;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }
}
