<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../../modelo/wishlist.php';
require '../../modelo/usuario.php';
require '../../modelo/correo.php';

$wishlistsAbandonados = Wishlist::mdlObtenerWishlistsAbandonados();

if ($wishlistsAbandonados === false) {
    return "No abandoned wishlists found";
}

$productosAgrupados = [];
foreach ($wishlistsAbandonados as $wishlist) {
    $id_usuario = $wishlist['id_usuario'];
    if (!isset($productosAgrupados[$id_usuario])) {
        $productosAgrupados[$id_usuario] = [];
    }
    $productosAgrupados[$id_usuario][] = $wishlist;
}

foreach ($productosAgrupados as $id_usuario => $wishlists) {
    $usuario = Usuario::mdlGetUsuarioActivo($id_usuario, 1);
    $nombre = $usuario['nombre'];
    $correo = $usuario['correo'];
    
    $enviar_correo = Correo::mdlWishlistAbandonado($correo, $nombre, $wishlists);

    if (!$enviar_correo) {
        $response['response'] = 'error';
        $response['data'] = 'No se pudo enviar el correo';
        echo json_encode($response);
    }
}