<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/wishlist.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
$id_producto = $_POST['id_producto'];

$verificarExistenciaWishlist = Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $id_producto);

if ($verificarExistenciaWishlist) {
    $response['response'] = 'error';
    $response['data'] = 'El producto ya existe en la wishlist';
    echo json_encode($response);
    return;
}

$agregarProductoWishlist = Wishlist::mdlAddProductoWishlist($id_usuario, $id_producto);

if (!$agregarProductoWishlist) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo agregar el producto';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = 'Producto agregado a la wishlist';
echo json_encode($response);
