<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['codigo_recover_password']) ||
    !isset($_POST['nuevo_password'])
) {
    $response['response'] = 'error';

    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$codigo_recover_password = $_POST['codigo_recover_password'];

$codigo_valido = Usuario::mdlVerifyCodigoAleatorio($id_usuario, $codigo_recover_password);

if (!$codigo_valido) {
    $response['response'] = 'error';
    $response['data'] = 'Código incorrecto';
    echo json_encode($response);
    return;
}

$nuevo_password = password_hash($_POST['nuevo_password'], PASSWORD_DEFAULT);

if (!Usuario::mdlUpdateUsuarioPassword($id_usuario, $nuevo_password)) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar la contraseña';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);