<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/correo.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['password']) ||
    !isset($_POST['nuevo_password'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$password = $_POST['password'];

$password_valido = Usuario::mdlVerifyUsuarioPassword($id_usuario, $password);

if (!$password_valido) {
    $response['response'] = 'error';
    $response['data'] = 'Contraseña incorrecta';
    echo json_encode($response);
    return;
}

$valor_anterior = ModeloGlobal::mdlSelect('usuario', $id_usuario);

$nuevo_password = password_hash($_POST['nuevo_password'], PASSWORD_DEFAULT);

if (!Usuario::mdlUpdateUsuarioPassword($id_usuario,$nuevo_password)) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar la contraseña';
    echo json_encode($response);
    return;
}

$enviar_correo = Correo::mdlUpdatePasswordMiPerfil($valor_anterior['correo'], $valor_anterior['nombre']);

if (!$enviar_correo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo enviar el correo';

    Usuario::mdlUpdateUsuarioPassword($id_usuario,password_hash($password, PASSWORD_DEFAULT));

    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'usuario', $id_usuario, $id_usuario, json_encode($valor_anterior));

$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);
