<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

// NECESITAMOS EL id_usuario, activo y el id del usuario activo
if (
    !isset($_POST['id']) ||
    !isset($_POST['id_usuario']) ||
    !isset($_POST['new_password'])
) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Datos incompletos'
    ]);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Id del usuario activo incorrecto.'
    ]);
    return;
}

$new_password = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
$id_usuario = $_POST['id_usuario'];
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $id_usuario));

$update = Usuario::mdlUpdateUsuarioPassword($id_usuario, $new_password);

if (!$update) {
    echo json_encode([
        'response' => 'error',
        'message' => 'No se pudo actualizar el password del usuario.'
    ]);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'usuario', $id_usuario, $id, $valor_anterior);

echo json_encode([
    'response' => 'success',
    'message' => 'Se actualizó correctamente el password de usuario.'
]);
http_response_code(200); // success
