<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/permiso_usuario.php';

if (!isset($_POST['id'])) {
    echo json_encode([
        'response' => 'error', 
        'message' => 'Datos incompletos, id del usuario no recibido',
    ]);
    return;
}

$id_usuario_activo = $_POST['id']; 
$usuarios_administracion = Usuario::mdlGetUsuariosAdministracion();

if (!$usuarios_administracion) {
    echo json_encode([
        'response' => 'error', 
        'message' => 'No se encontraron usuarios_administracion',
    ]);
    return;
}

// Agregamos sus permisos del sistema de cada uno
foreach($usuarios_administracion as $key => $value){
    $permisos = PermisoUsuario::mdlGetPermisoByUsuario($value['id_usuario']);
    $usuarios_administracion[$key]['permisos'] = array();
    if($permisos){
        $usuarios_administracion[$key]['permisos'] = $permisos;
    }
}

http_response_code(200); // success
echo json_encode([
    'response' => 'success', 
    'message' => 'Se encontraron los usuarios',
    'data' => $usuarios_administracion
]);