<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/wishlist.php';
require '../../modelo/producto.php';
require '../../modelo/precio.php';
require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (!isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['data'] = 'POST Error';
    echo json_encode($response);
    return;
}

$id_usuario = $_POST['id_usuario'];

$mdlGetWishlistUsuario = Wishlist::mdlGetWishlistUsuario($id_usuario);

$pagina = isset($_POST['pagina']) ? intval($_POST['pagina']) : 1;
$limite = isset($_POST['limite']) ? intval($_POST['limite']) : 12;

$productos_variacion_padre = array();

foreach ($mdlGetWishlistUsuario as $key_variaciones => $producto) {
    $id_producto = $producto['id_producto'];

    $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($id_producto);

    if (($producto_variacion === false) || ($producto_variacion['id_producto'] === $producto_variacion['id_producto_padre'])) {
        $productos_variacion_padre[$key_variaciones] = $producto;
    }
}

$total_productos = count($productos_variacion_padre);
$total_paginas = ceil($total_productos / $limite);

if ($pagina < 1) {
    $pagina = 1;
} elseif ($pagina > $total_paginas) {
    $pagina = $total_paginas;
}

$offset = ($pagina - 1) * $limite;

$paginado_productos = array_slice($productos_variacion_padre, $offset, $limite);

if (!$paginado_productos) {
    $response['response'] = 'error';
    $response['data'] = [];
    echo json_encode($response);
    return;
}

foreach ($paginado_productos as $key => $producto) {
    $id_producto = $producto['id_producto'];

    $precio_regular = Precio::mdlGetPrecioById($producto['id_precio']);
    
    $paginado_productos[$key]['precio']['id_precio_regular'] = $producto['id_precio'];
    $paginado_productos[$key]['precio']['precio_regular'] = $precio_regular['precio'];
    $paginado_productos[$key]['precio']['precio_descuento'] = null;
    
    if ($producto['id_precio_descuento'] !== null) {
        $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);
        
        $paginado_productos[$key]['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
        $paginado_productos[$key]['precio']['precio_descuento'] = $precio_descuento['precio'];
        
        $procentaje_descuento = 100 - ($paginado_productos[$key]['precio']['precio_descuento'] * 100) / $paginado_productos[$key]['precio']['precio_regular'];
        
        $paginado_productos[$key]['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
    }
    
    $imagenes = json_decode($producto['imagenes']);
    $imagenes_url = array();
    $url_servidor = Environment::getUrlServidor();
    
    foreach ($imagenes as $key_imagen => $imagen) {
        $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
        $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
    }
    
    $paginado_productos[$key]['imagenes'] = $imagenes_url;
    
    $calificacion = Producto::mdlGetCalificacionesProducto($id_producto);
    $paginado_productos[$key]['total_calificaciones'] = $calificacion['total_calificaciones'];
    $paginado_productos[$key]['promedio'] = $calificacion['promedio_estrellas'];
    $paginado_productos[$key]['wishlist'] = false;
    $paginado_productos[$key]['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $id_producto); 
}

$response['response'] = 'success';
$response['data'] = $paginado_productos;
$response['total_paginas'] = $total_paginas;
$response['pagina_actual'] = $pagina;

echo json_encode($response);
return;
