<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
// require '../../modelo/environment.php';
// require '../usuario/decodeUsuario.php';

const LIMITE_DE_CLIENTES_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_CLIENTES_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$clientes = Usuario::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_CLIENTES_POR_PAGINA);
$total_clientes = Usuario::mdlSearchTotal($filters, $termino_busqueda);

if (!$clientes) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron clientes';
    echo json_encode($response);
    return;
}

foreach ($clientes as $key => $cliente) {
    $clientes[$key]['nombre_completo'] = $cliente['nombre'] . ' ' . $cliente['apellido_paterno'] . ' ' . $cliente['apellido_materno'];
    $fecha = date($cliente['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $clientes[$key]['fecha_alta'] = $fechaFormat;
    
    // $clientes[$key]['fecha_alta'] = date('d/m/Y', strtotime($cliente['fecha_alta']));
}

$response['response'] = 'success';
$response['data'] = array(
    "clientes" => $clientes,
    "total_clientes" => $total_clientes['total'],
    "limite" => LIMITE_DE_CLIENTES_POR_PAGINA,
);

echo json_encode($response);