<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/odoo_cliente.php';
require '../../modelo/correo.php';
// Siempre que se utilice este modelo debe ser con require_once
require_once '../../modelo/odoo_auth.php';
require '../../modelo/environment.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['nombre']) ||
    !isset($_POST['apellido_paterno']) ||
    !isset($_POST['apellido_materno']) ||
    !isset($_POST['correo']) ||
    !isset($_POST['celular'])
) {
    $response['response'] = 'error';
    $response['data'] = 'POST Error';
    echo json_encode($response);
    return;
}

$ip = $_SERVER['REMOTE_ADDR'];
// $ip = "192.168.1.1";

$details = json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip={$ip}"));
// $pais = $details->geoplugin_countryCode;
$pais = "MX";

$user_agent = $_SERVER['HTTP_USER_AGENT'];
// $user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36";

$correo = $_POST['correo'];
$celular = (isset($_POST['celular'])) ? $_POST['celular'] : null;

$validar_usuario_existente = Usuario::mdlVerifyUsuarioExistente($correo, $celular);

if ($validar_usuario_existente) {
    $response['response'] = 'error';
    $response['data'] = 'El usuario ya existe';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$apellido_paterno = $_POST['apellido_paterno'];
$apellido_materno = $_POST['apellido_materno'];
$password = (isset($_POST['password'])) ? password_hash($_POST['password'], PASSWORD_DEFAULT) : null;
$fecha_nacimiento = (isset($_POST['fecha_nacimiento'])) ? $_POST['fecha_nacimiento'] : null;
$id_sexo = (isset($_POST['id_sexo'])) ? $_POST['id_sexo'] : null;
$uid_google = (isset($_POST['uid_google'])) ? $_POST['uid_google'] : null;
$uid_facebook = (isset($_POST['uid_facebook'])) ? $_POST['uid_facebook'] : null;

$agregarUsuario = Usuario::mdlAddUsuario(
    NULL,
    $nombre,
    $apellido_paterno,
    $apellido_materno,
    $correo,
    $celular,
    $password,
    $fecha_nacimiento,
    $id_sexo,
    $pais,
    $user_agent,
    $ip,
    $uid_google,
    $uid_facebook
);

if (!$agregarUsuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo agregar el usuario';
    echo json_encode($response);
    return;
}

$agregarUsuarioOdoo = OdooCliente::addClient($nombre, $apellido_paterno . ' ' . $apellido_materno, $celular, $correo, intval(OdooAuth::getClientCategoryId()));


// Obtenemos el id de la lista de precios "Precio Público" y la seteamos al usuario
// Esto es para que en la factura se aplique en MXN.
$price_list_id = OdooCliente::getPriceList('Precio Público')[0]['id'];
OdooCliente::updatePriceListCliente($agregarUsuarioOdoo, $price_list_id);
OdooCliente::updateLanguageMXCliente($agregarUsuarioOdoo);

if (!$agregarUsuarioOdoo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo agregar el usuario en Odoo';
    echo json_encode($response);
    return;
}

$actualizarUsuarioOdoo = Usuario::mdlUpdateUsuarioIdOdoo($agregarUsuario, $agregarUsuarioOdoo);

if (!$actualizarUsuarioOdoo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el usuario en Odoo';
    echo json_encode($response);
    return;
}

// $enviar_correo = Correo::mdlAddUsuario($correo, $nombre);
// $enviar_correo = Correo::mdlAddUsuario("andrea@andrea.com", "Andrea Yazmin");

// if (!$enviar_correo) {
//     $response['response'] = 'error';
//     $response['data'] = 'No se pudo enviar el correo';

//     $codigo_aleatorio = Usuario::mdlUpdateActivoUsuario($agregarUsuario, 0);

//     echo json_encode($response);
//     return;
// }

$usuario = Usuario::mdlGetUsuarioRegistro($agregarUsuario);

if (!$usuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo obtener el usuario';
    echo json_encode($response);
    return;
}

$usuario['id_usuario'] = Environment::encodeUser($agregarUsuario);

$usuario['foto_perfil'] = Environment::getUrlServidor() . $usuario['foto_perfil'];

$response['response'] = 'success';
$response['data'] = $usuario;
echo json_encode($response);
