<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/tipo_variacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre_variacion']) ||
    !isset($_POST['id_tipo_variacion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$nombre_variacion = $_POST['nombre_variacion'];
$id_tipo_variacion = $_POST['id_tipo_variacion'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('tipo_variacion', $id_tipo_variacion));

$tipo_variacion = TipoVariacion::mdlUpdateTipoVariacion($id_tipo_variacion, $nombre_variacion);

if (!$tipo_variacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizo el tipo_variacion';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'tipo_variacion', $id_tipo_variacion, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $tipo_variacion;

echo json_encode($response);