<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/tipo_soporte_tecnico.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_tipo_soporte_tecnico']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_tipo_soporte_tecnico = $_POST['id_tipo_soporte_tecnico'];
$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('tipo_soporte_tecnico', $id_tipo_soporte_tecnico));

$tipo_soporte_tecnico = TipoSoporteTecnico::mdlUpdateTipoSoporteTecnico($id_tipo_soporte_tecnico, $nombre, $descripcion, $activo);

if (!$tipo_soporte_tecnico) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el tipo de soporte técnico';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'tipo_soporte_tecnico', $id_tipo_soporte_tecnico, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);
