<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/subcategoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_subcategoria']) ||
    !isset($_POST['id_categoria']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion']) ||
    !isset($_POST['url_pagina'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_subcategoria = $_POST['id_subcategoria'];
$id_categoria = $_POST['id_categoria'];
$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];
$url_pagina = $_POST['url_pagina'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('subcategoria', $id_subcategoria));

$subcategoria = Subcategoria::mdlUpdateSubcategoria($id_subcategoria, $id_categoria, $nombre, $descripcion, $url_pagina);

if (!$subcategoria) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizo la subcategoria';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'subcategoria', $id_subcategoria, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $subcategoria;

echo json_encode($response);
