<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/categoria.php';
require '../../modelo/subcategoria.php';
require '../../modelo/environment.php';
$response = array();

if (!isset($_POST['url_pagina'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$url_pagina = $_POST['url_pagina'];
$subcategorias = Subcategoria::mdlGetSubcategoriaByNombreCategoria($url_pagina);

$nombre_categoria = Categoria::mdlGetCategoriaById($subcategorias[0]['id_categoria']);

if (!$subcategorias) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron subcategorias';
    return;
}

foreach ($subcategorias as $key => $value) {
    $subcategorias[$key]['imagen'] = Environment::getUrlServidor() . $value['imagen'];
}

$response['response'] = 'success';

$response['categoria'] = $nombre_categoria;
$response['data'] = $subcategorias;

echo json_encode($response);