<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/ruta.php';
require '../../modelo/subcategoria.php';
$response = array();

if (!isset($_POST['id_categoria'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_categoria = $_POST['id_categoria'];
$subcategorias = Subcategoria::mdlGetSubcategoriasActivoByIdCategoria($id_categoria);

foreach ($subcategorias as $key => $value) {
    $subcategorias[$key]['imagen'] = Ruta::getRutaSitioAdministracion() . '/' . $value['imagen'];
}

if (!$subcategorias) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron subcategorias';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = $subcategorias;
echo json_encode($response);
