<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/subcategoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_subcategoria'])
) {

    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

    if (!$id_usuario) {
        $response['response'] = 'error';
        $response['data'] = 'Id del usuario incorrecto.';
        echo json_encode($response);
        return;
    }

    $id_subcategoria = $_POST['id_subcategoria'];

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('subcategoria', $id_subcategoria));

    $subcategoria = Subcategoria::mdlDeleteSubcategoria($id_subcategoria);

    if (!$subcategoria) {
        $response['response'] = 'error';
        $response['data'] = 'No se eliminó la subcategoria';
    } else {

        ModeloHistory::mdlAddNewRegister('delete', 'subcategoria', $id_subcategoria, $id_usuario, $valor_anterior);

        $response['response'] = 'success';
        $response['data'] = $subcategoria;
    }
    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}
