<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/subcategoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_categoria']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['url_pagina'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';

    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_categoria = $_POST['id_categoria'];
$nombre = $_POST['nombre'];
$descripcion = (isset($_POST['descripcion']) && $_POST['descripcion'] != '') ? $_POST['descripcion'] : NULL;
$url_pagina = $_POST['url_pagina'];

$subcategoria = Subcategoria::mdlAddSubcategoria($id_categoria, $nombre, $descripcion, NULL, $url_pagina);

if (!$subcategoria) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la subcategoria';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'subcategoria', $subcategoria, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $subcategoria;

echo json_encode($response);