<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/respuesta.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

// NECESITAMOS EL id_respuesta, respuesta y el id del usuario activo
if (
    !isset($_POST['id']) ||
    !isset($_POST['id_respuesta']) ||
    !isset($_POST['respuesta'])
) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Datos incompletos'
    ]);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Id del usuario activo incorrecto.'
    ]);
    return;
}

$respuesta = $_POST['respuesta'];
$id_respuesta = $_POST['id_respuesta'];
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('respuesta', $id_respuesta));

$respuesta = Respuesta::mdlUpdateSoloRespuesta($id_respuesta, $respuesta);

if (!$respuesta) {
    echo json_encode([
        'response' => 'info',
        'message' => 'La respuesta no ha cambiado'
    ]);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'respuesta', $id_respuesta, $id, $valor_anterior);

echo json_encode([
    'response' => 'success',
    'message' => 'Se actualizó correctamente la respuesta.'
]);
http_response_code(200); // success

