<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/reclamo_devolucion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_orden']) ||
    !isset($_POST['id_estado_reclamo']) ||
    !isset($_POST['motivo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_orden = $_POST['id_orden'];
$id_estado_reclamo = $_POST['id_estado_reclamo'];
$motivo = $_POST['motivo'];

$reclamo_devolucion = ReclamoDevolucion::mdlAddReclamoDevolucion($id_usuario, $id_orden, $id_estado_reclamo, $motivo);

if (!$reclamo_devolucion) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el reclamo de devolución';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'reclamo_devolucion', $reclamo_devolucion, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $reclamo_devolucion;

echo json_encode($response);
