<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/proveedor.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (
    !isset($_POST['id_proveedor']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_proveedor = $_POST['id_proveedor'];
$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];
// $activo = $_POST['activo'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('proveedor', $id_proveedor));

$proveedor = Proveedor::mdlUpdateProveedor($id_proveedor, $nombre, $descripcion);

if (!$proveedor) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el proveedor';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'proveedor', $id_proveedor, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);