<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/proveedor.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_proveedor']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_proveedor = $_POST['id_proveedor'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('proveedor', $id_proveedor));

$proveedor = Proveedor::mdlUpdateActivoProveedor($id_proveedor, $activo);

if (!$proveedor) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el campo activo.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'proveedor', $id_proveedor, $id_usuario, $valor_anterior);

$response['response'] = 'success';

echo json_encode($response);