<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/proveedor.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$proveedor = Proveedor::mdlAddProveedor($nombre, $descripcion);

if (!$proveedor) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el proveedor';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('add', 'proveedor', $proveedor, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $proveedor;

echo json_encode($response);